Public Class Form1
    Dim distanceMultiplier As Double
    Dim startTruck As Integer

    '
    ' Handler for moving the truck
    '
    Private Sub trackbarTruck_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles trackbarTruck.Scroll
        sfnetTruck.Left = startTruck + (trackbarTruck.Value * distanceMultiplier)
    End Sub
    '
    ' Handler for changing the Blower and Cutaway control
    '
    Private Sub trackbarLevel_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles trackbarLevel.Scroll
        sfnetBlower.AnalogIntValue1 = trackbarLevel.Value
        sfnetCutaway.Level = trackbarLevel.Value
        textboxLevelInt.Text = trackbarLevel.Value.ToString()
    End Sub
    '
    ' Handler for turning ON the valve
    '
    Private Sub radiobuttonValveOn_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radiobuttonValveOn.CheckedChanged
        If sfnetValve.BandsCollection.Count > 0 Then
            sfnetValve.BandsCollection(0).DiscreteValue = True
            sfnetValve.BandsCollection(1).DiscreteValue = False
        End If
    End Sub
    '
    ' Handler for turning OFF the valve
    '
    Private Sub radiobuttonValveOff_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radiobuttonValveOff.CheckedChanged
        If sfnetValve.BandsCollection.Count > 0 Then
            sfnetValve.BandsCollection(0).DiscreteValue = False
            sfnetValve.BandsCollection(1).DiscreteValue = True
        End If
    End Sub
    '
    ' Handler for exiting the application
    '
    Private Sub buttonExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonExit.Click
        Application.Exit()
    End Sub
    '
    ' Initialization Code
    '
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        '
        ' Construction of the default component values
        '
        trackbarLevel.Value = 0
        sfnetCutaway.Level = trackbarLevel.Value
        sfnetBlower.AnalogIntValue1 = trackbarLevel.Value
        textboxLevelMax.Text = trackbarLevel.Maximum.ToString()
        textboxLevelMin.Text = trackbarLevel.Minimum.ToString()
        textboxLevelInt.Text = trackbarLevel.Value.ToString()
        sfnetValve.BandsCollection(0).DiscreteValue = True
        sfnetValve.BandsCollection(1).DiscreteValue = False
        '
        ' Compute distance for the truck to travel
        '
        Dim truckDistance As Integer
        truckDistance = Me.Size.Width - sfnetTruck.Width - sfnetTruck.Left
        distanceMultiplier = truckDistance / (trackbarTruck.Maximum - trackbarTruck.Minimum)
        trackbarTruck.Value = 0
        startTruck = sfnetTruck.Left
        sfnetTruck.Left = startTruck + (trackbarTruck.Value * distanceMultiplier)

    End Sub
End Class
